import pygame


class DeathScreen:
    def __init__(self, screen):
        self.screen = screen
        self.big_font = pygame.font.SysFont("arial", 60, bold=True)
        self.small_font = pygame.font.SysFont("arial", 24)

    def draw(self, score, kills):
        overlay = pygame.Surface(self.screen.get_size())
        overlay.set_alpha(180)
        overlay.fill((0, 0, 0))
        self.screen.blit(overlay, (0, 0))

        w, h = self.screen.get_size()

        title = self.big_font.render("YOU DIED", True, (200, 0, 0))
        score_text = self.small_font.render(f"Score: {score}", True, (255, 255, 255))
        kill_text = self.small_font.render(f"Kills: {kills}", True, (255, 255, 255))
        hint = self.small_font.render("Press R to Restart", True, (180, 180, 180))

        self.screen.blit(title, title.get_rect(center=(w//2, h//2 - 80)))
        self.screen.blit(score_text, score_text.get_rect(center=(w//2, h//2)))
        self.screen.blit(kill_text, kill_text.get_rect(center=(w//2, h//2 + 30)))
        self.screen.blit(hint, hint.get_rect(center=(w//2, h//2 + 90)))
